﻿/**************************************************
 * Copyright:ESUNNY
 * Author: ZZY
 * Date:2014-08-11
 * Description:FTDAPI.h，ZCEAPI对外函数声明文件。
 * Note:请不要修改该文件
 * Change History:
 * <Date>	| <Author>  | <Description>
 *-------------------------------------------------*
  2019-08-10| ZZY		| 1.删除了API_Recv接口。
						| 2.修改API_ConnectEx接口。
						| 3.删除API_Connect接口。
						| 4.调整API_GFString 接口参数bufsize类型和返回值说明；API_SFString接口参数bufsize的类型。
						| 5.将原Config.h 文件内容合并到此文件，并修改API_FIELDTYPE，API_DFFLAG，API_DFSTATUS类型定义。
						| 6.修改了对ExchgPackageCallBack的注释说明。
						| 7.调整了ftd_api_init接口函数的定义。
						| 8.统一接口命名规范,ftd_api_init()--> API_Init(),ftd_api_getVersion()-->API_GetVersion(),ftd_api_stop() --> API_Stop()
						| 9.明确API_SFDouble参数精度的注释说明和类型定义。
						| 10.明确修改各个接口中数据域号fid的类型为unsigned short
						| 11.修改对API_FirstField API_NextField 返回值的定义和注释的提示说明
						| 12.删除取当前数据域的接口API_CFType,API_CFDT,API_CFInt,API_CFChar,API_CFDouble,API_CFString. 请根据API_FirstField和API_NextField返回的fid,取其类型和值.
						| 13.函数API_CreateExchgConnection 增加两个绑定线程到CPU的参数.
						| 14,修改API_Login,API_Logout,API_Send 返回值类型,由API_BOOL改为代表错误码的int类型.
						| 15,删除API_SetOpenCallBack, API_SetLoginCallBack, API_SetLogoutCallBack 三个设置回调的接口. 同时修改API_Login,API_Logout接口,增加一个MsgPackageHandle * 参数,返回应答数据包.
						| 16,修改API_GetVersion 第二个参数的类型及返回值说明.
  2020-01-03|  ZZY		| 1.删除API_CreateExchgConnection函数中心跳间隔和心跳超时两个参数。
  2020-03-13|  ZZY		| 1.修改API_Now的返回值类型。由void改为int。
						| 2.在说明中明确API设置和返回的时间是北京时间。
						| 3.API_Send返回值增加3028（太过频繁的查询）
						| 4.修改API_Copy的返回类型为int
  2020-04-18|  ZZY		| 1.增加查询流的定义
  2021-05-21|  ZZY		| 1.去除查询流；2. 删除API_ConnectEx接口，增加API_Connect接口；
						| 3.API_CreateExchgConnection函数增加是否自动启动业务驱动线程参数, 同时增加接口API_RunEvent.
  2025-01-02|  ESUNNY	| 1.增加API_GFULong,API_SFULong接口

 *************************************************/

#ifndef FTDAPI_H_
#define FTDAPI_H_

#ifdef WIN32//windows平台定义
#define FTDAPI_CALL __cdecl		//调用约定
#else		//Linux平台定义
#define FTDAPI_CALL 
#endif 

typedef unsigned short API_UINT16;
typedef unsigned char API_BYTE;
typedef	unsigned int API_UINT32;
typedef	unsigned long long API_UINT64;

//日期类型
#pragma pack(push,1)

typedef struct tagDateTime
{
	API_UINT16 year;
	API_BYTE  month, day, hour, minute, second;
	API_UINT32 microsec;
}API_DateTime;

#pragma pack(pop)

typedef int API_BOOL;
#define API_TRUE	1
#define API_FALSE	0

/*交易所*/
typedef int MARKET_ID;
#define MARKET_ZCE 1

//域类型
enum API_FIELDTYPE
{
	FTNULL = 0,
	FTCHAR = 1,
	FTLONG = 2,
	FTSTRING = 3,
	FTDOUBLE = 4,
	FTDATETIME = 5,
	FTINT64 = 6
};
//数据流标示
typedef API_BYTE API_DFFLAG;
#define	DFF_DIALOG		0 		//对话流
#define	DFF_PRIVATE		1		//私有流
#define	DFF_BROADCAST	2		//广播流

//数据流状态常数
enum API_DFSTATUS
{
	DFS_CLOSED = 0,		//连接断开
	DFS_OPENED = 1,		//刚刚建立连接
	DFS_NEGOTIATEKEY = 2,	//刚刚协商密钥，还没有登录。非加密链路等同于 DFS_OPENED
	DFS_LOGIN_OK = 3	//已经登录成功
};

#ifdef __cplusplus
class MsgPackage;
class ExchangeConnection;
/*数据包句柄*/
typedef MsgPackage* MsgPackageHandle;
/*交易所连接对象句柄*/
typedef ExchangeConnection* ExchgConnectionHandle;
#else
/*数据包句柄*/
typedef void* MsgPackageHandle;
/*交易所连接对象句柄*/
typedef void* ExchgConnectionHandle;
#endif

/*
* 包含数据的回调函数,回调结束后，请不要再使用pkg。
* 函数请返回1；
* Note：如果你采用11协议登录广播流，请确保回调函数是线程可重入的。
*/
typedef int (FTDAPI_CALL* ExchgPackageCallBack)(void* CallBackArg, ExchgConnectionHandle conn, MsgPackageHandle pkg);
/*连接状态的回调函数*/
typedef void (FTDAPI_CALL* ExchgConnectionCallBack)(void* CallBackArg, ExchgConnectionHandle, int error_code, const char* error_text);

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

	/*****************************************************
	*Function:	API_GetVersion
	*Summary:	得到API的版本号字符串，如:1.0.12.1。
	*Parameters:
		versionbuf:	存放获取的版本号字符串的缓冲区地址
		buflen:（入参+出参）存放版本号字符串缓冲区大小的指针
	*Return :
		缓冲区太小返回-1，buflen返回需要的最小缓冲区长度.
		成功返回版本字符串长度(含\0结束符)。
	******************************************************/
	int FTDAPI_CALL API_GetVersion(char* versionbuf, unsigned int* buflen);

	/*****************************************************
	*Function:	API_Init
	*Summary:	初始化API库。
	*Parameters:
		logFilePath:	API日志文件路径，存在并且用户有写权限。
		APIDataPath:	API私有数据保存目录，存在并且用户有写权限。
	*Return :
		成功返回API_TRUE,失败返回API_FALSE.
	******************************************************/
	API_BOOL FTDAPI_CALL API_Init(const char* logFilePath, const char* APIDataPath);

	/*****************************************************
	*Function:	API_Stop
	*Summary:	停止API库的使用，非退出前不要调用。
	*Parameters:
	*Return :
	******************************************************/
	void FTDAPI_CALL API_Stop();

	/*****************************************************
	*Function:	API_AllocPackage
	*Summary:	创建通信数据包。
	*Parameters:
	*Return :
		成功返回数据包对象句柄，不然返回空指针。
	******************************************************/
	MsgPackageHandle FTDAPI_CALL API_AllocPackage();

	/*****************************************************
	*Function:	API_FreePackage
	*Summary:	回收数据包对象。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
	*Return :
	******************************************************/
	void FTDAPI_CALL API_FreePackage(MsgPackageHandle pkg);

	/*---------------------------报文数据操作--------------------------*/

	/*****************************************************
	*Function:	API_GetPID
	*Summary:	获取报文PID。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
	*Return :
		成功返回数据PID，不然返回0xFFFFF
	******************************************************/
	int FTDAPI_CALL API_GetPID(MsgPackageHandle pkg);

	/*****************************************************
	*Function:	API_SetPID
	*Summary:	设置报文PID。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		pid:要设置的PID
	******************************************************/
	void FTDAPI_CALL API_SetPID(MsgPackageHandle pkg, int pid);

	/*****************************************************
	*Function:	API_GetFieldType
	*Summary:	取得某数据域的当前数据类型。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
	*Return :
		返回指定数据包中指定数据域的数据域类型。没有该数据域返回FTNULL。
	******************************************************/
	enum API_FIELDTYPE FTDAPI_CALL API_GetFieldType(MsgPackageHandle pkg, API_UINT16 fid);

	/*****************************************************
	 *Function:	API_GFChar
	 *Summary:	以Char型取指定数据域的值。
	 *Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		def:没有该数据域时的默认返回值。
	 *Return :
		返回指定数据包中指定数据域的字段值。没有该数据域返回def。
	 ******************************************************/
	char FTDAPI_CALL API_GFChar(MsgPackageHandle pkg, API_UINT16 fid, char def 
#ifdef __cplusplus 
		= ' '
#endif 
	);

	/*****************************************************
	*Function:	API_SFChar
	*Summary:	对指定数据域设置Char类型的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		val:要设置值。
	*Return : 错误码
		0:代表赋值成功
		-1:代表该数据域不能用该类型赋值
		-99:数据包非法
	******************************************************/
	int FTDAPI_CALL API_SFChar(MsgPackageHandle pkg, API_UINT16 fid, char val);

	/*****************************************************
	*Function:	API_GFInt
	*Summary:	以INT型取指定数据域的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		def:没有该数据域时的默认返回值。
	*Return :
		返回指定数据包中指定数据域的字段值。没有该数据域返回def。
	******************************************************/
	int FTDAPI_CALL API_GFInt(MsgPackageHandle pkg, API_UINT16 fid, int def 
#ifdef __cplusplus 
		= 0
#endif 
	);

	/*****************************************************
	*Function:	API_SFChar
	*Summary:	对指定数据域设置整数类型的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		val:要设置值。
	*Return : 错误码
		0:代表赋值成功
		-1:代表该数据域不能用该类型赋值
		-99:数据包非法
	******************************************************/
	int FTDAPI_CALL API_SFInt(MsgPackageHandle pkg, API_UINT16 fid, int val);

    /*****************************************************
	*Function:	API_GFULong
	*Summary:	以UNSIGNED LONG LONG型取指定数据域的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		def:没有该数据域时的默认返回值。
	*Return :
		返回指定数据包中指定数据域的字段值。没有该数据域返回def。
	******************************************************/
	API_UINT64 FTDAPI_CALL API_GFULong(MsgPackageHandle pkg, API_UINT16 fid, API_UINT64 def 
#ifdef __cplusplus 
		= 0
#endif 
	);

	/*****************************************************
	*Function:	API_SFULong
	*Summary:	对指定数据域设置整数类型的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		val:要设置值。
	*Return : 错误码
		0:代表赋值成功
		-1:代表该数据域不能用该类型赋值
		-99:数据包非法
	******************************************************/
	int FTDAPI_CALL API_SFULong(MsgPackageHandle pkg, API_UINT16 fid, API_UINT64 val);

	/*****************************************************
	 *Function:	API_GFDouble
	 *Summary:	以Double型取指定数据域的值。
	 *Parameters:
		 pkg:通过函数API_AllocPackage返回的数据包句柄。
		 fid:数据域号。
		 def:没有该数据域时的默认返回值。
	 *Return :
		返回指定数据包中指定数据域的字段值。没有该数据域返回def。
	 ******************************************************/
	double FTDAPI_CALL API_GFDouble(MsgPackageHandle pkg, API_UINT16 fid, double def 
#ifdef __cplusplus 
		= 0.0
#endif 
	);

	/*****************************************************
	*Function:	API_SFDouble
	*Summary:	对指定数据域设置Double类型值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		val:要设置值。
		precision:Double值的精度。支持最小1位,最大15位精度。
	*Return : 错误码
		0:代表赋值成功
		-1:代表该数据域不能用该类型赋值
		-99:数据包非法
	*Note:
		1.郑商所交易系统目前支持的最大值为:12位整数2位精度.or 8位整数4位精度.具体参见参考手册.如果填写超出范围浮点数,将不能被有效传递.
	******************************************************/
	int FTDAPI_CALL API_SFDouble(MsgPackageHandle pkg, API_UINT16 fid, double val, unsigned int precision 
#ifdef __cplusplus 
		= 4 
#endif 
	);

	/*****************************************************
	*Function:	API_GFString
	*Summary:	以String型取指定数据域的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		buf:保存获取值的地址。
		bufsize:（入参+出参）保存获取值的地址大小。
	*Return :
	   返回值>0: 
	   当返回值<=bufsize,返回获取字符串的长度；
	   当返回值>bufsize表示给定的缓冲区太小,只是把bufsize长度的数据复制到了buf中，返回值为取完整数据需要的缓冲区长度。
	   返回值==0，表示取不到该字段的值或给的参数就不可能取到(比如buf为空,bufsize为0)；
	******************************************************/
	int FTDAPI_CALL API_GFString(MsgPackageHandle pkg, API_UINT16 fid, char* buf, unsigned int bufsize);

	/*****************************************************
	*Function:	API_SFString
	*Summary:	对指定数据域设置String类型值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		buf:设置的数据地址。
		bufsize:设置的数据长度。
	*Return : 错误码
		0:赋值成功
		-1:该fid不能用该类型赋值
		-2:bufsize为0并且pkg中fid字段不存在。
		-99:数据包非法
	******************************************************/
	int FTDAPI_CALL API_SFString(MsgPackageHandle pkg, API_UINT16 fid, const char* buf, unsigned int bufsize);

	/*****************************************************
	*Function:	API_GFDateTime
	*Summary:	以API_DateTime型取指定数据域的值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		val:保存获取值的地址。
	*Return :
	   成功获取返回API_TRUE;不然返回API_FALSE。
	*Note ：val是按照北京时间（UTC+8）解析。比如：API_DateTime(2019,11,23,9,45,08,234208),表示的是北京时间2019年11月23日09点45分08秒234208微秒。
	******************************************************/
	API_BOOL FTDAPI_CALL API_GFDateTime(MsgPackageHandle pkg, API_UINT16 fid, API_DateTime* val);

	/*****************************************************
	*Function:	API_SFDateTime
	*Summary:	对指定数据域设置API_DateTime类型值。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
		val:设置的数据地址。
	*Return : 错误码
		0:赋值成功
		-1:该fid不能用该类型赋值
		-2:不可传输的时间（本地保存，不可传输和拷贝）
		-99:数据非法
	*Note : 
		val时间是按照北京时间（UTC+8）解析。比如：API_DateTime(2019,11,23,9,45,08,234208),表示的是北京时间2019年11月23日09点45分08秒234208微秒。
		API不对设置的具体时间的合法性验证，用户要自己保证。比如，月份设为15，可设置成功，但是经过传输和拷贝后具体值不保证，不确定。
	******************************************************/
	int FTDAPI_CALL API_SFDateTime(MsgPackageHandle pkg, API_UINT16 fid, const API_DateTime* val);

	/*****************************************************
	*Function:	API_FieldIsNull
	*Summary:	判断指定数据包中某个数据域是否为空。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
		fid:数据域号。
	*Return :
	   空返回API_TRUE;不然返回API_FALSE。
	*Note:
	    该函数等效于:API_GetFieldType() == API_FIELDTYPE::FTNULL
	******************************************************/
	API_BOOL FTDAPI_CALL API_FieldIsNull(MsgPackageHandle pkg, API_UINT16 fid);

	/*****************************************************
	 *Function:	API_ClearField
	 *Summary:	清除某个特定的数据域的值。
	 *Parameters:
		 pkg:通过函数API_AllocPackage返回的数据包句柄。
		 fid:数据域号。
	******************************************************/
	void FTDAPI_CALL API_ClearField(MsgPackageHandle pkg, API_UINT16 fid);

	/*****************************************************
	*Function:	API_ClearAll
	*Summary:	清除数据报里的所有数据域。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
	******************************************************/
	void FTDAPI_CALL API_ClearAll(MsgPackageHandle pkg);

	/*****************************************************
	*Function:	API_Copy
	*Summary:	把source的数据全部复制到pkg。
	*Parameters:
		pkg，source:通过函数API_AllocPackage返回的数据包句柄。
	*Return 复制成功返回0；不然返回非零错误码。
	******************************************************/
	int FTDAPI_CALL API_Copy(MsgPackageHandle pkg, MsgPackageHandle source);

	/*****************************************************
	*Function:	API_FirstField
	*Summary:	找到遍历数据包的第一个数据域。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
	*Return :
		>0: 遍历时第一个数据域号的fid.
		-1:pkg 为空包。
		-99:pkg非法。
	*Note:
		在遍历数据包是必须首先调用API_FirstField.
		API_FirstField 和 API_NextField 结束之间不能对pkg进行增加和删除数据域.
		函数不是线程安全的,不要多线程同时遍历pkg.
	******************************************************/
	int FTDAPI_CALL API_FirstField(MsgPackageHandle pkg);

	/*****************************************************
	*Function:	API_NextField
	*Summary:	得到遍历数据包的下一个数据域的编号。
	*Parameters:
		pkg:通过函数API_AllocPackage返回的数据包句柄。
	*Return :
		>0: 遍历数据包时下一个数据域号的fid.
		-1:已到结尾。
		-99:pkg非法。
	******************************************************/
	int FTDAPI_CALL API_NextField(MsgPackageHandle pkg);

	/*****************************************************
	*Function:	API_Now
	*Summary:	取得当前本地系统的时间。
	*Parameters:
		dt:保存取到时间的地址。
	*Return:
		成功获取时间返回0，失败返回-1；
	******************************************************/
	int FTDAPI_CALL API_Now(API_DateTime* dt);

	/*****************************************************
	*Function:	API_CreateExchgConnection
	*Summary:	创建交易所连接对象。
	*Parameters:
		encrypt:是否加密。
		commpress:是否压缩。
		market:连接的市场。目前只能取MARKET_ZCE
		thread_bind_cpu:连接的业务驱动线程绑定到CPU的编号(从0开始). 参数值为负数或超出本机CPU个数不绑定.
		thread_bind_cpu_udp:指定广播流采用UDP协议接收时驱动线程绑定到CPU的编号(从0开始). 参数值为负数或超出本机CPU个数不绑定.
		drive_auto: 是否自动启动业务驱动线程。如果为API_TRUE，则该连接对象会自动启动业务驱动线程；
					否则，API不再启动驱动线程，用户必须自行启动线程并调用该连接的事件驱动函数。@see API_RunEvent
	*Return :
		返回创建的连接对象句柄。
	*Note：
		没有登录广播流或广播流登录协议不是UDP接收时，thread_bind_cpu_udp 设置无效。
		drive_auto 为API_FALSE 时 thread_bind_cpu 设置无效。
	******************************************************/
	ExchgConnectionHandle FTDAPI_CALL API_CreateExchgConnection(API_BOOL encrypt, API_BOOL commpress, MARKET_ID market, 
		int thread_bind_cpu, int thread_bind_cpu_udp, API_BOOL drive_auto = API_TRUE);

	/*****************************************************
	*Function:	API_SetConnectionOpt
	*Summary:	预设连接的属性参数。
	*Parameters:
		conn:交易所连接对象句柄
		keepIdle:连接空闲时间。Linux平台单位秒，Windows单位为毫秒。
		keepInterval:连接检测间隔。Linux平台单位秒，Windows单位为毫秒。
		keepCount:检测次数。
	*Return :
		成功设置返回0，否则返回错误码。
	*Note:请在发起连接之前调用该函数设置。
	******************************************************/
	int FTDAPI_CALL API_SetConnectionOpt(ExchgConnectionHandle conn, int keepIdle, int keepInterval, int keepCount);

	/*****************************************************
	*Function:	API_Connect
	*Summary:	发起与交易所连接
	*Parameters:
		conn:交易所连接对象句柄。
		Ip:交易前置IP地址
		port:交易前置端口
		wait:超时等待时间. 毫秒数.
		errMsg:输出参数。返回错误信息的内存空间。由用户分配，最少64个字节。
	*Return :
		错误码:
		 0					:连接成功
		3000				:参数有误
		3027				:回调中不能调用
		3035				:连接交易所前置失败
	*Note：
		其中参数userID，dataFlow 要和在此连接登录时的信息一致。不然登录会失败。
	******************************************************/
	int FTDAPI_CALL API_Connect(ExchgConnectionHandle conn, const char* IP, unsigned short port, int wait, char* errMsg);

	/*****************************************************
	*Function:	API_Connected
	*Summary:	判断交易所连接对象是否已经连接到交易所
	*Parameters:
		conn:交易所连接对象句柄。
	*Return :
		若连接对象连接到了交易所，返回API_TRUE,否则返回API_FALSE。
	******************************************************/
	API_BOOL FTDAPI_CALL API_Connected(ExchgConnectionHandle conn);

	/*****************************************************
	*Function:	API_RunEvent
	*Summary:	当用户线程替代连接自动线程驱动连接业务时，用户线程需要调用的事件驱动函数。
	*Parameters:
		conn:交易所连接对象句柄。
	*Return:
	*	0: 事件正常处理；
		3000				:参数有误
		3029				:非法调用
		其他，说明事件处理过程中发生错误，链路中断开，事件处理结束。
	*Note :
		如果创建连接对象时，采用的是自动启动业务驱动线程（drive_auto = API_TRUE），请不要调用该函数。
		该函数不是线程安全，不要多线程同时调用。
	******************************************************/
	int FTDAPI_CALL API_RunEvent(ExchgConnectionHandle conn);

	/*****************************************************
	*Function:	API_Login
	*Summary:	登录到交易所
	*Parameters:
		conn:交易所连接对象句柄。
		reqPkg:包含登录信息的数据包句柄
		Wait:登录超时等待时间。单位秒
		rspPkg: 输出参数. 保存登录应答包句柄的指针. 如果没有应答为空指针.
	*Return :
		登录交易所错误码:
		0:						:登录成功
		3000					:参数错误
		3001					:连接还未建立
		3002					:链路协商数据发送错误
		3003					:链路协商超时
		3004					:登录数据发送错误
		3005					:登录超时
		4001					:登录协议版本号错误
		3018					:数据流标示错误
		3019					:不能重复登录
		3020					:登录没有指定席位
		3022					:协商密钥验证失败
		3027					:回调中不能调用
		3051					:协商密钥生成错误
		//-------------------------后台错误码
		2007				  	：数据流登录模式不正确
		610						: 非法交易员代码
		262						:交易员已被挂起
		673						: 非法登录请求
		674						: 非法口令
		675						: 你不能从该工作站登录系统
		2005					：登录协议版本错误
		40						: 不能从该前置登录系统,请求私有流数量过多
		7001					: 重复登录
	*Note:
		*rspPkg 指向的MsgPackage 只读. 
		*该函数为同步函数,不要在API的回调函数中调用.
	******************************************************/
	int FTDAPI_CALL API_Login(ExchgConnectionHandle conn, MsgPackageHandle reqPkg, double Wait, MsgPackageHandle* rspPkg);

	/*****************************************************
	*Function:	API_Logout
	*Summary:	退出登录
	*Parameters:
		conn:交易所连接对象句柄。
		reqPkg:包含登出信息的数据包句柄
		Wait:登录超时等待时间。单位秒
		rspPkg: 输出参数. 保存登出应答包句柄的指针. 如果没有应答为空指针.
	*Return :
		登出交易所错误码:
		0						:登出成功
		3000					:参数错误
		3006					:没有登录无法登出
		3018					:数据流标示错误
		3027					:回调中不能调用
		//------------------后台错误码
		2007					：数据流登录模式不正确
		610						: 非法交易员代码
		673						: 非法登录请求
	*Note:
		*rspPkg 指向的MsgPackage 只读. 
		*该函数为同步函数,不要在API的回调函数中调用.
	******************************************************/
	int FTDAPI_CALL API_Logout(ExchgConnectionHandle conn, MsgPackageHandle reqPkg, double Wait, MsgPackageHandle* rspPkg);

	/*****************************************************
	 *Function:	API_Send
	 *Summary:	发送一个数据包
	 *Parameters:
		conn:交易所连接对象句柄。
		pkg:包含登出信息的数据包句柄
	 *Return :
		发送错误码:
		0						:成功
		3000					:参数错误
		3009					:没有登录不能发送
		3010					:数据包格式错误
		3015					:数据包不能被识别,可能是API版本过低
		3016					:数据发送错误
		3018					:数据流标示错误
		3024					:数据包PID错误
		3025					:数据包为空
		3028					:太过频繁的查询
	******************************************************/
	int FTDAPI_CALL API_Send(ExchgConnectionHandle conn, MsgPackageHandle pkg);

	/*****************************************************
	*Function:	API_DisConnect
	*Summary:	断开与交易所的连接
	*Parameters:
		conn:交易所连接对象句柄。
	******************************************************/
	void FTDAPI_CALL API_DisConnect(ExchgConnectionHandle conn);

	/*****************************************************
	*Function:	API_FreeExchgConnection
	*Summary:	关闭并释放交易所连接对象
	*Parameters:
		conn:交易所连接对象句柄。
	******************************************************/
	void FTDAPI_CALL API_FreeExchgConnection(ExchgConnectionHandle conn);

	/*****************************************************
	*Function:	API_GetDataFlowStatus
	*Summary:	取得数据流状态
	*Parameters:
		conn:交易所连接对象句柄。
		DataFlowFlag:数据流标示
	*Return :
		返回具体数据流的状态
	******************************************************/
	enum API_DFSTATUS FTDAPI_CALL API_GetDataFlowStatus(ExchgConnectionHandle conn, API_DFFLAG DataFlowFlag);

	/*****************************************************
	*Function:	API_SetCloseCallBack
	*Summary:	设置指定的交易所连接对象链路断开时的回调函数
	*Parameters:
		conn:交易所连接对象句柄。
		callback:要设置的链路状态回调函数
		CallBackArg:要设置的链路状态回调函数的参数，它将最终传给链路状态回调函数。
	******************************************************/
	void FTDAPI_CALL API_SetCloseCallBack(ExchgConnectionHandle conn, ExchgConnectionCallBack callback, void* CallBackArg);

	/*****************************************************
	*Function:	API_SetErrorCallBack
	*Summary:	设置指定的连接交易所对象的链路出错时的回调函数
	*Parameters:
		conn:交易所连接对象句柄。
		callback:要设置的链路状态回调函数
		CallBackArg:要设置的链路状态回调函数的参数，它将最终传给链路状态回调函数。
	******************************************************/
	void FTDAPI_CALL API_SetErrorCallBack(ExchgConnectionHandle conn, ExchgConnectionCallBack callback, void* CallBackArg);

	/*****************************************************
	*Function:	API_SetRecvCallBack
	*Summary:	设置有数据处理时的回调函数
	*Parameters:
		conn:交易所连接对象句柄。
		callback:要设置的返回数据包回调函数
		CallBackArg:要设置的返回数据包回调函数的参数，它将最终传给返回数据包回调函数。
	******************************************************/
	void FTDAPI_CALL API_SetRecvCallBack(ExchgConnectionHandle conn, ExchgPackageCallBack callback, void* CallBackArg);

#ifdef __cplusplus
}
#endif /* __cplusplus */ 

#endif
