﻿/*
* @file ZCEAPIDemo.cpp
* @brief
*		该示例程序适用于ZCEAPI版本2.0版本. 1.x版本请参考之前示例程序。
* @note
*		编译和运行此Demo时,请注意修改服务器IP地址和端口,以及修改交易员账户信息,以便程序能够正常演示.
*		该示例以对话流为例,广播流和私有流处理机制一致.
*		该示例程序主要是简要演示ZCEAPI的使用过程和使用方式,没有考虑实用性.
*		示例程序不保证实现没有bug,千万不能机械模仿,要根据自己的程序需要进行合理的设计.
*/

#include <iostream>
#include <string>
#include <cstring>
#include <exception>
#include <stdexcept>
#include "FTDAPI.h"			
#include "APICallBack.h"
#include "FieldID.h"

#ifdef WIN32

#pragma comment(lib,"ZCEFTDAPI.lib")

#endif // WIN32

#define ERR_SUCCESS 0

inline void PkgSetString(MsgPackageHandle pkg, API_UINT16 fid, const char* buf, unsigned int bufsize)
{
	if (API_SFString(pkg, fid, buf, bufsize) != 0)
		throw std::invalid_argument("The fid cannot set String");
}

inline void PkgSetInt(MsgPackageHandle pkg, API_UINT16 fid, int val)
{
	if (API_SFInt(pkg, fid, val) != 0)
		throw std::invalid_argument("The fid cannot set Int");
}

inline void PkgSetChar(MsgPackageHandle pkg, API_UINT16 fid, char val)
{
	if (API_SFChar(pkg, fid, val) != 0)
		throw std::invalid_argument("The fid cannot set Char");
}

inline void PkgSetDouble(MsgPackageHandle pkg, API_UINT16 fid, double val, unsigned int precision)
{
	if (API_SFDouble(pkg, fid, val, precision) != 0)
		throw std::invalid_argument("The fid cannot set Double");
}

inline void PkgSetDateTime(MsgPackageHandle pkg, API_UINT16 fid, const API_DateTime* val)
{
	if (API_SFDateTime(pkg, fid, val) != 0)
		throw std::invalid_argument("The fid cannot set DateTime");
}

inline void PkgSetULong(MsgPackageHandle pkg, API_UINT16 fid, unsigned long long val)
{
	if (API_SFULong(pkg, fid, val) != 0)
		throw std::invalid_argument("The fid cannot set ULong");
}

//登录函数
bool ZCELogin(ExchgConnectionHandle conn, short int DFF, const char* ParticipantId, const char* UserId)
{
	//登录请求包(PID):0x00016
	MsgPackageHandle  APIpkg;       //数据包句柄
	APIpkg = API_AllocPackage();    //分配一个API数据包

	short int	DataFlowFlag = DFF;							//数据流号,0->对话流,1->私有流,2->广播流
	char		ServerAppName[] = "ZCE_DEMO_MT";			//会员应用系统名称
	char		ProtocolVersion[10] = "2";					//使用FTD版本号,目前=2
	char		IpAddr2[20] = "192.168.199.100";			//登录者的IP地址,如192.168.199.100
	char		INIT_PASSWORD[20] = "12345678";				//联络初始密钥
	char		AUTH_SERIAL_NO[20] = "12345678-12345678";	//序列号:12345678-12345678
	char		AUTH_CODE[20] = "12345678-12345678";		//授权码:12345678-12345678
	int			FRspSeqNO = 0;								//请求序列号
	double		LoginTimeout = 3.5;							//登录超时,这个数代表秒数.
	char		Password[] = "88888";						//密码
	//填写登陆数据包. 
	//数据字段的设置可能会失败,请关注返回值. 失败的原因主要是字段类型和设置的类型不匹配.
	API_SetPID(APIpkg, 0x00016);
	if (ERR_SUCCESS != API_SFInt(APIpkg, FID_DataFlowFlag, DataFlowFlag))
		std::cout << "Fail to set FID_DataFlowFlag" << std::endl;
	if (ERR_SUCCESS != API_SFString(APIpkg, FID_ParticipantId, ParticipantId, strlen(ParticipantId)))
		std::cout << "Fail to set FID_ParticipantId" << std::endl;

	//如果觉得每次判断返回值太麻烦, 那么建议至少需要在测试代码判断,比如如下: (但是不推荐)
#ifdef DEBUG
	if (ERR_SUCCESS != API_SFString(APIpkg, FID_UserId, UserId, strlen(UserId)))
		std::cout << "Fail to set FID_UserId" << std::endl;
#else
	API_SFString(APIpkg, FID_UserId, UserId, strlen(UserId));
#endif // DEBUG
	//也可以采用异常处理的方式，这样不用每次判断返回值
	try
	{
		PkgSetString(APIpkg, FID_Password, Password, strlen(Password));
		PkgSetString(APIpkg, FID_ServerAppName, ServerAppName, strlen(ServerAppName));
		PkgSetString(APIpkg, FID_ProtocolVersion, ProtocolVersion, strlen(ProtocolVersion));
		PkgSetString(APIpkg, FID_IpAddr, IpAddr2, strlen(IpAddr2));
		PkgSetInt(APIpkg, FID_SequenceNo, FRspSeqNO);
		PkgSetString(APIpkg, FID_INIT_PASSWORD, INIT_PASSWORD, strlen(INIT_PASSWORD));
		PkgSetString(APIpkg, FID_AUTH_SERIAL_NO, AUTH_SERIAL_NO, strlen(AUTH_SERIAL_NO));
		PkgSetString(APIpkg, FID_AUTH_CODE, AUTH_CODE, strlen(AUTH_CODE));
	}
	catch (const std::exception&)
	{
		std::cout << "Set Pkg Field value error" << std::endl;
		return false;
	}
	
	//定义返回数据包输出参数. 注意是数据包句柄类型指针,而不是数据包类型指针.
	MsgPackageHandle RspPkg;
	//发起登录
	int ret_login = API_Login(conn, APIpkg, LoginTimeout, &RspPkg);
	if (ret_login == ERR_SUCCESS)
	{
		//登录成功. 可以通过RspPkg获取交易所返回的登录应答包内容.
		//接下来尝试获取交易所时间.
		API_DateTime exchange_dt;
		if(API_GFDateTime(RspPkg, FID_ExchangeDateTime, &exchange_dt) == API_TRUE)
			std::cout << "ExchangeDateTime: " << exchange_dt.year << "-" << (int)exchange_dt.month 
						<< "-" << (int)exchange_dt.day << " " << (int)exchange_dt.hour << ":" 
						<< (int)exchange_dt.minute << std::endl;
	}
	else
	{
		//登录失败.
		if (RspPkg != nullptr)   //说明有错误的登录应答包.可以取出应答包里面的数据.
		{
			int Errcode = API_GFInt(RspPkg, FID_ErrorCode);		//Errcode == ret_login
			//下面以获取ErrorText为例,说明API_GFString 在获取不确定长度的字符串时的注意事项.
			char msg[64] = {0};
			int NeedLen = API_GFString(RspPkg, FID_ErrorText, msg, sizeof(msg) -1 );
			if ((int)sizeof(msg) - 1  < NeedLen)
			{
				//说明错误信息没取完.
				char* msgbuf = new char[NeedLen + 1];
				msgbuf[NeedLen] = '\0';
				API_GFString(RspPkg, FID_ErrorText, msgbuf, NeedLen);
				std::cout << "Login error: " << Errcode << " ErrText: " << msgbuf << std::endl;
			}
			else
			{
				std::cout << "Login error: " << Errcode << " ErrText: " << msg << std::endl;
			}
		}
	}
	std::cout << "Login retrun: " << ret_login << std::endl;
	//释放掉我们分配的API数据包对象
	API_FreePackage(APIpkg);
	return (ret_login == ERR_SUCCESS);
}

//客户信息查询
bool ZCELogout(ExchgConnectionHandle conn, short int DFF, const char* ParticipantId, const char* UserId)
{
	//客户信息查询请求(PID):0x0000C数据包
	MsgPackageHandle  APIpkg;       //数据包句柄
	APIpkg = API_AllocPackage();    //分配一个API数据包
	//下面填写报单查询请求数据包然后再将其发送出去(目前未用的字段可以不填写) 
	API_SetPID(APIpkg, 0x0000C);
	try
	{
		PkgSetInt(APIpkg, FID_DataFlowFlag, DFF);
		PkgSetString(APIpkg, FID_ParticipantId, ParticipantId, strlen(ParticipantId));
		PkgSetString(APIpkg, FID_UserId, UserId, strlen(UserId));
	}
	catch (const std::exception&)
	{
		return false;
	}
	//定义返回数据包输出参数. 注意是数据包句柄类型指针,而不是数据包类型指针.
	MsgPackageHandle RspPkg;
	int ret_logout = API_Logout(conn, APIpkg, 1.5, &RspPkg);
	if (ret_logout == ERR_SUCCESS)
	{
		//登出成功.可以从RspPkg中获取所需字段. 同Login
		API_DateTime exchange_dt;
		if (API_GFDateTime(RspPkg, FID_ExchangeDateTime, &exchange_dt) == API_TRUE)
			std::cout << "ExchangeDateTime, Hour: " << (int)exchange_dt.hour << ":" 
						<< (int)exchange_dt.minute << std::endl;
	}
	else
	{
		//登出失败. 可参考Login.
		if (RspPkg != nullptr)   //说明有错误的登录应答包.可以取出应答包里面的数据.
		{
			int Errcode = API_GFInt(RspPkg, FID_ErrorCode);		//Errcode == ret_logout
			std::cout << "Logout Error: " << Errcode << std::endl;
		}
	}
	std::cout << "Logout retrun: " << ret_logout << std::endl;
	//释放掉我们分配的API数据包对象
	API_FreePackage(APIpkg);
	return (ret_logout == ERR_SUCCESS);
}

//下期货限价单
bool Order_LimitPrice(ExchgConnectionHandle conn, const char* ParticipantId, const char* UserId, const char* ClientId)
{
	//报单录入请求(PID):0x00003
	MsgPackageHandle  APIpkg;       //数据包句柄
	APIpkg = API_AllocPackage();    //分配一个API数据包

	char		OrderLocalId[24] = " ";						//[24]  委托编号
	char		InstrumentId[20] = "SR503";					//[20]	合约编码,如期货为WS509,期权为WS509C1600
	short int	Direction = 0;								//		买卖方向,可以不用输入,0->买,1->卖,2->所有
	short int	OffsetFlag = 0;								//		开平仓标记,0->开仓,1->平仓,2->强平
	short int	HedgeFlag = 1;								//		投保标记,1->投机,3->套期保值
	double		StopPrice = 0;								//[12]  止损价格,FTDFloatType<12,4>,目前未用
	double		LimitPrice = 0;								//[12]  限价(或止损定单的保护价),FTDFloatType<12,4>
	int			VolumeTotalOrginal = 5;						//[4]	原始总申报数量(以手为单位),二进制网络序
	short int	OrderType = 0;								//		报单类型,0->限价,1->市价,3->止损,7->组合定单,101->跨期套利确认,102->持仓套保确认,103->请求报价,104->期权权力行使,105->报价请求响应,106->期权权力放弃
	short int	MatchCondition = 3;							//		报单成交属性,1->即时全部成交,2->即时部分成交,3->当日有效,4->取消前有效,5->指定日期前有效
	char		MatchSession = ' ';							//		报单成交时间,目前未用
	API_DateTime	ValidThrough = {2025,1,1,0,0,0,0};		//[8]	有效时间约束,YYYYMMDD,目前未用
	int			MinimalVolume = 0;							//[4]	最小成交量,二进制网络序,目前未用
	short int	AutoSuspend = 1;							//		自动挂起标志,1->真,0->假,目前未用
	API_DateTime	InsertTime = {2025,1,1,0,0,0,0};		//[20]  录入时间
	char		MessageReference[100] = "自定义数据";	    //[100]	用户自定义数据,备注信息
	short int	CMBType = 0;								//		组合定单类型,0-SPZ,1-SPD,2-IPS,3-BUL,4-BER,5-BLT,6-BRT,7-STD,8-STG,9-PRT
	char		SecondLeg[20] = " ";						//[20]	组合定单第二腿
	unsigned long long	OrderSysId2 = 0;					//[8]	合同编号

	//下面填写下单请求数据包然后再将他们发送出去(目前未用的字段可以不填写) 
	API_SetPID(APIpkg, 0x00003);
	try
	{
		PkgSetString(APIpkg, FID_OrderLocalId, OrderLocalId, strlen(OrderLocalId));
		PkgSetString(APIpkg, FID_UserId, UserId, strlen(UserId));
		PkgSetString(APIpkg, FID_ParticipantId, ParticipantId, strlen(ParticipantId));
		PkgSetString(APIpkg, FID_ClientId, ClientId, strlen(ClientId));
		PkgSetString(APIpkg, FID_InstrumentId, InstrumentId, strlen(InstrumentId));
		PkgSetInt(APIpkg, FID_Direction, Direction);
		PkgSetInt(APIpkg, FID_OffsetFlag, OffsetFlag);
		PkgSetInt(APIpkg, FID_HedgeFlag, HedgeFlag);
		PkgSetDouble(APIpkg, FID_StopPrice, StopPrice, 4);
		PkgSetDouble(APIpkg, FID_LimitPrice, LimitPrice, 4);
		PkgSetInt(APIpkg, FID_VolumeTotalOrginal, VolumeTotalOrginal);
		PkgSetInt(APIpkg, FID_OrderType, OrderType);
		PkgSetInt(APIpkg, FID_MatchCondition, MatchCondition);
		PkgSetChar(APIpkg, FID_MatchSession, MatchSession);
		PkgSetDateTime(APIpkg, FID_ValidThrough, &ValidThrough);
		PkgSetInt(APIpkg, FID_MinimalVolume, MinimalVolume);
		PkgSetInt(APIpkg, FID_AutoSuspend, AutoSuspend);
		PkgSetDateTime(APIpkg, FID_InsertTime, &InsertTime);
		PkgSetString(APIpkg, FID_MessageReference, MessageReference, strlen(MessageReference));
		PkgSetInt(APIpkg, FID_CmbType, CMBType);
		PkgSetString(APIpkg, FID_SecondLeg, SecondLeg, strlen(SecondLeg));
		PkgSetULong(APIpkg, FID_OrderSysId2, OrderSysId2);
	}
	catch (const std::exception&)
	{
		std::cout << "Set Pkg Field Error" << std::endl;
		return false;
	}
	
	bool ret;
	if (API_Send(conn, APIpkg) == ERR_SUCCESS)
	{
		ret = true;
	}
	else
	{
		std::cout << "Fail to send Order_LimitPrice!" << std::endl;
		ret = false;
	}

	//释放掉我们分配的API数据包对象
	API_FreePackage(APIpkg);
	return ret;
}

int main(int argc, char** argv)
{
	//初始化ZCEAPI。
	if (API_Init("./log", "./APIData") == API_TRUE)		//这里使用了 . 相对路径，只是表示一个路径，不代表推荐这种方式。而且它也不是一个好的方式。
	{
		std::cout << "Succeed in Init API!!!" << std::endl;
	}
	else
	{
		std::cout << "Fail to Init API!!!" << std::endl;
		return 1;
	}

	//获取ZCEAPI版本号
	char Version[16] = { 0 };
	unsigned int vlen = sizeof(Version);
	if (API_GetVersion(Version, &vlen) == -1)
	{
		std::cout << "Fail to Get the Version! You need a buf: " << vlen << " chars length." << std::endl;
		return 2;
	}
	else
	{
		std::cout << "ZCEAPI Version: " << Version << std::endl;
	}

	//设置连接对象的属性
	API_BOOL Encrypt = API_TRUE;		    //是否加密 1:是,0:否
	API_BOOL Commpress = API_TRUE;		    //是否压缩 1:是,0:否
	MARKET_ID Market_ID = MARKET_ZCE;		//即郑商所 1
	int cpunum_for_driver = 1;				//我们把连接的驱动线程绑到指定的(编号为1)CPU核上.
	int cpunum_for_udp = -1;				//我们这里把可能的UDP接收线程不做CPU绑定.(本示例中登录的是对话流,不会启动UDP接收线程,所有更没必要为这个绑定参数设置正常CPU编号,即便设置也无效)

	//建立对话流连接对象
	ExchgConnectionHandle DialogConn = API_CreateExchgConnection(Encrypt, Commpress, Market_ID, cpunum_for_driver, cpunum_for_udp);
	if (DialogConn == NULL)
	{
		std::cout << "Can not create Dialog connection to ZCE！" << std::endl;
		return 3;
	}

	//设置连接属性值，Linux平台单位秒，Windows单位为毫秒
#ifdef WIN32
	API_SetConnectionOpt(DialogConn, 5000, 2000, 5000);
#else
	API_SetConnectionOpt(DialogConn, 5, 2, 5);
#endif

	//设置回调函数
	ExchgConnectionCallBack OnClose = OnAPIClose;		//链路状态断开回调函数
	ExchgConnectionCallBack ErrorCallBack = OnErrors;	//链路状态出错回调函数
	ExchgPackageCallBack recvCallBack = OnRec;		    //收到数据包回调函数

	//设置链路断开回调函数.
	int close_arg = 99;				//注意:一定要注意参数的声明周期. 确保在回调的时候还能访问.
	API_SetCloseCallBack(DialogConn, OnClose, &close_arg);
	//设置收到数据包回调函数
	char* recv_arg = new char[64];	//注意:一定要注意参数的声明周期. 确保在回调的时候还能访问.
	strcpy(recv_arg, "A recv arg");
	API_SetRecvCallBack(DialogConn, recvCallBack, recv_arg);
	//设置链路出错回调. 如果你不需要向回调函数传递参数,那么最后一个参数可以选择为 NULL.
	API_SetErrorCallBack(DialogConn, ErrorCallBack, NULL);

	char IpAddr[20] = "218.29.68.231";      //交易所的登录地址服务的IP地址,如218.29.68.231
	int port = 22677;						//连接交易所的端口
	char ParticipantId[20] = "0052";		//交易会员编码
	char UserId[15] = "00520010";           //交易员编码
	char ClientId[15] = "00010002";
	char ErrMsg[128];
	//下面发起对交易所的连接
	std::cout << "Connect ZCE ..." << std::endl;
	int ret_connect = API_Connect(DialogConn, IpAddr, port, 5000, ErrMsg);
	if (ret_connect != ERR_SUCCESS)
	{
		//连接失败
		std::cout << "Fail to Connect ZCE, Return Code: " << ret_connect << std::endl;
		delete[] recv_arg;
		return 4;
	}
	else   //连接成功
	{
		//登录交易所
		std::cout << "Login ZCE ..." << std::endl;
		if (ZCELogin(DialogConn, DFF_DIALOG, ParticipantId, UserId))
		{
			//登录成功后,对话流可以向交易所发送命令.我们模拟下单和合约查询
			std::cout << "************************************************************" << std::endl;
			std::cout << "请输入命令: ";
			char command;
			bool exit_now = false;
			while (!exit_now)
			{
				std::cin >> command;
				switch (command)
				{
				case 'Q':
					exit_now = true;
					break;
				case 'L':
					Order_LimitPrice(DialogConn, ParticipantId, UserId, ClientId);
					break;
				default:
					break;
				}
			}
			//登出交易所
			if (!ZCELogout(DialogConn, DFF_DIALOG, ParticipantId, UserId))
				std::cout << "Fail to Logout ZCE!!!" << std::endl;
		}
		//断开并释放交易所连接对象
		API_FreeExchgConnection(DialogConn);
		//停止ZCEAPI服务
		API_Stop();
		delete[] recv_arg;
		return 0;
	}
}
