﻿/**
 * @file	APICallBack.cpp
 * @brief 	声明API回调函数的处理示例.
 * Note:
 */

#include <iostream> 
#include <string>
#include <cstring>
#include <cassert>
#include "APICallBack.h" 
#include "FieldID.h" 

//链路断开的回调函数
//该回调函数通知链路断开. 用户可以采取措施比如再次发起连接等.
void OnAPIClose(void * CallBackArg, ExchgConnectionHandle conn, int error_code, const char* error_text)
{
	//回调回来的CallBackArg 是在设置链路回调时候设置的. 本示例是为指向 99 的int 的指针. 
	int* close_arg = (int*)CallBackArg;
	std::cout << "链路断开, 回调设置的参数:" << *close_arg << std::endl; 
    std::cout << "错误代码:" << error_code << " 错误信息:" << error_text << std::endl;
	//注意:	不建议在回调函数中直接发起连接,更不可在该回调函数中调用登录函数再次登录.
	//		建议采用消息传递的方式,通知其他线程做相应的处理
}

//收到数据包的回调函数
int OnRec(void * CallBackArg, ExchgConnectionHandle conn, MsgPackageHandle pkg)
{
	//CallBackArg是之前设置的一个Char* 指针.
	char* ArgStr = (char*)CallBackArg;
	if (ArgStr == NULL)		//不会发生
	{
		std::cout << "Something Strange happened!" << std::endl;
	}
	else
	{
		std::cout << "CallBackArg: " << ArgStr << std::endl;
	}
	int PkgPID = API_GetPID(pkg);
	switch (PkgPID)
	{
	case 0x10003:		//报单应答
	{
		int order_errcode = API_GFInt(pkg, FID_ErrorCode);
		if (order_errcode == 0)
		{
			API_UINT64 SysID = API_GFULong(pkg, FID_OrderSysId2);
			std::cout << "Order System ID: " << SysID << std::endl;
		}
		else
		{
			std::cout << "Order Insert error: " << order_errcode << std::endl;
		}
		//-- 下面以该数据包为例，演示以下数据包遍历读取的使用。 
		//-- 注意：只是演示使用方式，并不是推荐采用遍历的方式读取类似的数据包。
		int fid = API_FirstField(pkg);
		while (fid > 0)
		{
			API_FIELDTYPE f_type = API_GetFieldType(pkg, fid);
			switch (f_type)
			{
			case FTNULL:
				//空类型，不会到这个逻辑
				break;
			case FTCHAR:
			{
				char f_value = API_GFChar(pkg, fid);
				std::cout << "FID: " << fid << ", Type: Char, value: " << f_value << std::endl;
			}
				break;
			case FTLONG:
			{
				if (fid == FID_VolumeTotalOrginal)
				{
					int order_volume = API_GFInt(pkg, fid);
					std::cout << "The order volume is: " << order_volume << std::endl;
				}
			}
				break;
			case FTSTRING:
			{
				if (fid == FID_UserId)
				{
					char user_id[32] = { 0 };
					int ret_len = API_GFString(pkg, fid, user_id, sizeof(user_id) - 1);
					assert(ret_len < (int)sizeof(user_id));
					std::cout << "The order owner is: " << user_id << std::endl;
				}
			}
				break;
			case FTDOUBLE:
			{
				if (fid == FID_LimitPrice)
				{
					double order_price = API_GFDouble(pkg, fid);
					std::cout << "The order price is: " << order_price << std::endl;
				}
			}
				break;
			case FTDATETIME:
			{
				if (fid == FID_InsertTime)
				{
					API_DateTime order_dt = {0, 0, 0, 0, 0, 0, 0};
					if (API_TRUE == API_GFDateTime(pkg, fid, &order_dt))
					{
						std::cout << "The order insertTime is: " << (int)order_dt.hour << ":" << (int)order_dt.minute 
							<< ":" << (int)order_dt.second << std::endl;
					}
				}
			}
				break;
			case FTINT64:
			{
				API_UINT64 f_value = API_GFULong(pkg, fid);
				std::cout << "FID: " << fid << ", Type: FTINT64, value: " << f_value << std::endl;
			}
				break;
			default:
				break;
			}
			fid = API_NextField(pkg);
		}
	}
		break;
	default:
		break;
	}
    return 0;
}

//出错的回调函数
void OnErrors(void * CallBackArg, ExchgConnectionHandle conn, int error_code, const char* error_text)
{
	//CallBackArg == null. 这是之前设置回调函数时候设置的.
	if (CallBackArg != NULL)
		std::cout << "Something Strange happened!" << std::endl;
    std::cout << "错误代码:" << error_code << "    " << "错误正文:" << error_text << std::endl;
}
